

********************************************************************************************************************************************************************
********************************************************************************************************************************************************************
*** Replication do-file for "The Power of Religion"
*** by Jeanet Sinding Bentzen and Gunes Gokmen
*** June, 2022
********************************************************************************************************************************************************************
********************************************************************************************************************************************************************



**********************************************************************************
**********************************************************************************
*** Figure 4: Persistent influence of past high gods on the likelihood of various religious laws today
**********************************************************************************

*** One can create a dataset of coefficients from 51 regressions using the code below first (or directly use the saved coefficients in figure4_coeffs.dta)
/*
clear
clear matrix
clear mata
set maxvar 32000
use all_laws_god, clear

tempname figure4_coeffs
postfile `figure4_coeffs' str12 mean_num nr mean_df_short mean_coeff_short mean_se_short using figure4_coeffs.dta, replace
foreach j in  01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 ///
20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 ///
44 45 46 47 48 49 50 51  {
reghdfe mean_`j' god, a(continent)
post `figure4_coeffs' (`"`j'_mean"') (`j') (e(df_r)) (`=_b[god]') (`=_se[god]') 
}

postclose `figure4_coeffs' 
use figure4_coeffs
merge 1:1 nr using labels
drop _merge
gen p_val  = (2 * ttail( mean_df_short , abs( mean_coeff_short / mean_se_short )))
replace p_val=round(p_val, 0.001)
gen lowerbound_90 = mean_coeff_short - 1.645*mean_se_short
gen upperbound_90 = mean_coeff_short + 1.645*mean_se_short
gsort -mean_coeff_short
gen laws_order = _n
label var laws_order "Laws ranked according to size of parameter estimate"
save figure4_coeffs, replace 
*/


**********************************************
*** To create Figure 4 of the effect of high gods on religious laws, for all different types of laws
use figure4_coeffs, clear

* gen lawnames_short= name /* create a duplicate of the names of the laws, and then shorten the descriptions so that it looks better on graph */
* sencode lawnames_short, g(laws) /* destring the names of the laws and make them numeric so that they can be graphed */

* Graph
set scheme plotplain

eclplot mean_coeff_short lowerbound_90 upperbound_90 laws, ytick(1(1)51,tlength(tiny) tlwidth(vvthin)) /// 
horizontal xline(0) aspectratio(1) estopts(msize(vsmall) msymbol(circle) ) ciopts(msize(vsmall) lwidth(thin))  /// 
ytitle("Religious Laws Today",size(small)) xtitle("Effect of Past High Gods on Religious Laws Today",size(small)) ylabel(1(1)51, labsize(tiny)) xlabel(-.4(.2).8, labsize(vsmall))

